// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedure for creating a true One Time Pad file.
//.................................................
#define	BLOCK_SIZE	16

// Define the BHEX instruction that changes a hex value
// in al into two hex digits in ah and al.
//.....................................................
#define	BHEX __asm _emit 0xd4 __asm _emit 0x10

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	LPTSTR				lpszNA;
extern	HWND				hMainWindow;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpIconPointer;
extern	LPCTSTR				lpszStopSign;
extern	LPCTSTR				lpszTOTPFile;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	DWORD				dwOldHelpNumber;
extern	HWND				hEditListWindow;
extern	BOOL				bEditWindowDisplayed;
extern	LPBYTE				lpKeyBuffer1;
extern	DWORD				dwLineCount;
extern	DWORD				dwLastLine;
extern	DWORD				dwCharOnLastLine;
extern	DWORD				dwCharInLine;
extern	HANDLE				hSendersEvent;
extern	HANDLE				hSendersOpen;
extern	TCHAR				szBuffer[80];
extern	HWND				hEditWindow;
extern	NUMBERFMT			nFormatInfo;
extern	LPTSTR				lpMyCmdLine;
extern	LPTSTR				lpMyCmdFile;

// Variables for viewing the contents of a true one time pad file.
//................................................................
LPCTSTR			lpszTOTPContents = "TOTPCONTENTS";
LPBYTE			lpTOTPFileName;
TCHAR			szTOTPFile[MAX_PATH];
HANDLE			hTOTPFile;
LARGE_INTEGER	liRandomBytesLeft;
TCHAR			szTOTPStats[] = "%s - %s Random Bytes Left";

// View a true one time pad in a virtual list window.
//...................................................
VOID ViewTrueOneTimePad()
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liMax;
	OPENFILENAME	ofn;
	RECT			rect;
	DWORD			dwBytesRead;
	BOOL			bResult;

	bProcessInProgress = TRUE;

	dwOldHelpNumber = ChangeHelpTopic(IDH_VIEWTOTPFILES);

	// See if we have a command line file to process.
	//...............................................
   	if (lpMyCmdLine)
	{
		ZeroMemory(&szTOTPFile,sizeof(szTOTPFile));
		CopyMemory(&szTOTPFile,lpMyCmdFile,MAX_PATH);
		lpMyCmdLine = 0;

		// Make sure we have a valid true one time pad file.
		//..................................................
		hTOTPFile = IsValidTruePadFile((LPTSTR)&szTOTPFile);
		
		if (!hTOTPFile)
		{
			goto TOTPEnd;
		}
	}
	else
	{
		// Initialize the OPENFILENAME structure.
		//.......................................
		InitializeOFN(&ofn,SAVE_TOTPFILES);

		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = szTOTPFile;
		ofn.nMaxFile = sizeof(szTOTPFile);
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("True One Time Pad Files [.pad]\0*.pad\0All Files [*.*]\0*.*\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select a True One Time Pad File to View");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_SHOWHELP);
		ofn.lpstrDefExt = NULL;
		ofn.lpfnHook = MyOFNHookProc;

		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		while(TRUE)
		{
			// Now select an encrypted file to view the contents of.
			//......................................................
			ZeroMemory(&szTOTPFile,sizeof(szTOTPFile));

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto TOTPEnd;
			}
			SaveDirName((LPBYTE)&szTOTPFile,SAVE_TOTPFILES | SAVE_SOURCE,TRUE);

			// Check out the file. It has to be a valid true one time pad file.
			//.................................................................
			hTOTPFile = IsValidTruePadFile((LPTSTR)&szTOTPFile);

			if (hTOTPFile)
			{
				break;
			}
		}
	}
	// Get a pointer to the file name.
	//................................
	lpTOTPFileName = PathFindFileName((LPCTSTR)&szTOTPFile);
	EmptyTheMessageQue();

	// Allocate a buffer to be used by the view procedure.
	//....................................................
	lpKeyBuffer1 = AllocateMemory(128);
	if (!lpKeyBuffer1)
	{
		goto TOTPEnd;
	}
	// Get the size of the file.
	//..........................
	li.QuadPart = GetMyFileSize((LPTSTR)&szTOTPFile,hTOTPFile);
	if (li.QuadPart == -1)
	{
		goto TOTPEnd;
	}
	// Setup the maximum number of bytes in a true one time pad file
	// we can handle.
	//...............................................................
	__asm
	{
		xor		edx,edx
		mov		eax,-1
		mov		ecx,BLOCK_SIZE
		mul		ecx
		mov		liMax.LowPart,eax
		mov		liMax.HighPart,edx
	}
	if (li.QuadPart > liMax.QuadPart)
	{
		dwLineCount = 4294967295;
		dwCharOnLastLine = BLOCK_SIZE;
	}
	else
	{
		__asm
		{
			mov		edx,li.HighPart
			mov		eax,li.LowPart
			mov		ecx,BLOCK_SIZE
			div		ecx
			mov		dwLineCount,eax
			mov		dwCharOnLastLine,edx
		}
		if (dwCharOnLastLine == 0)
		{
			dwCharOnLastLine = BLOCK_SIZE;
		}
		else
		{
			dwLineCount++;
		}
	}
	dwLastLine = (dwLineCount - 1);

	// Calculate the number of random bytes left in the file.
	//.......................................................
	liMax.QuadPart = PAD_ID_SIZE;
	liMax.QuadPart = SetMyFilePointer((LPTSTR)&szTOTPFile,hTOTPFile,liMax.QuadPart,FILE_BEGIN);
	if (liMax.QuadPart == -1)
	{
		goto TOTPEnd;
	}
	bResult = ReadMyFile((LPTSTR)&szTOTPFile,hTOTPFile,&liMax.QuadPart,
						  sizeof(LARGE_INTEGER),&dwBytesRead,NULL);
	if (!bResult)
	{
		goto TOTPEnd;
	}
	liRandomBytesLeft.QuadPart = (li.QuadPart - liMax.QuadPart);

	// Create our event for viewing the contents of the
	// tsc encrypted file.
	//.................................................
	hSendersEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("SendersEvent"));
	if (!hSendersEvent)
	{
		ErrorProcedure(TEXT("SendersEvent"),IDS_CREATEEVENT,MB_OK);
		goto TOTPEnd;
	}
	// Create the window to display the true one time pad key file contents in.
	// Use hEditWindow and bEditWindowDisplayed
	//.........................................................................
	GetClientRect(hMainWindow,&rect);

	hEditWindow = CreateWindowEx(0,lpszTOTPContents,lpszNullString,
								 WS_CAPTION | WS_CHILD | WS_SYSMENU | 
								 WS_VISIBLE | WS_CLIPCHILDREN,
								 rect.left,rect.top+37,
								 rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);

	if (!hEditWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto TOTPEnd;
	}
	// Open the event object.
	//.......................
	hSendersOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("SendersEvent"));
	if (!hSendersOpen)
	{
		DestroyWindow(hEditWindow);
		goto TOTPEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hSendersEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	TOTPEnd:

	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,128);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (hSendersOpen)
	{
		CloseHandle(hSendersOpen);
		hSendersOpen = 0;
	}
	if (hSendersEvent)
	{
		CloseHandle(hSendersEvent);
		hSendersEvent = 0;
	}
	if (hTOTPFile)
	{
		CloseMyHandle((LPTSTR)&szTOTPFile,hTOTPFile);
		hTOTPFile = 0;
	}
	ChangeHelpTopic(dwOldHelpNumber);
	bProcessInProgress = FALSE;
}

// Register the window class for viewing the contents of a
// true one time pad file.
//........................................................
BOOL RegisterTOTPWindow()
{
	WNDCLASS	wc;

	wc.style		 = 0;
	wc.lpfnWndProc	 = (WNDPROC)TOTPWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpszTOTPFile);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszTOTPContents;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for viewing the contents of a true time time pad file.
//........................................................................
LRESULT CALLBACK TOTPWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_CREATE:
		{
			HMENU			hTOTPWinMenu;
			MENUITEMINFO	mii;
			TCHAR			szInBuffer[332];	
			TCHAR			szFormatedNumber[64];

			// Disable the move menu item on the window menu.
			//...............................................
			hTOTPWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hTOTPWinMenu,SC_MOVE,FALSE,&mii);

			// Setup the name of the file and the number of random bytes left.
			//................................................................
			_i64toa(liRandomBytesLeft.QuadPart,(LPBYTE)&szInBuffer,10);
			GetNumberFormat(LOCALE_USER_DEFAULT,0,(LPCTSTR)&szInBuffer,
				            &nFormatInfo,(LPTSTR)&szFormatedNumber,sizeof(szFormatedNumber));
			StringCbPrintf(szInBuffer,sizeof(szInBuffer),szTOTPStats,lpTOTPFileName,
						  szFormatedNumber);
			SetWindowText(hWnd,(LPCTSTR)&szInBuffer);

			// Setup the virtual list view window.
			//....................................
			hEditListWindow = CreateTOTPListView(hWnd);
			if (!hEditListWindow)
			{
				return(-1);
			}
			SetFocus(hEditListWindow);
			bEditWindowDisplayed = TRUE;
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			ListView_SetBkColor(hEditListWindow,GetSysColor(COLOR_WINDOW));			
		}
		break;

		case WM_SIZE:
		{
			// Resize the virtual list view window.
			//.....................................
			ResizeTOTPListView(GetDlgItem(hWnd,IDC_TOTPLISTVIEW),hWnd);
		}
		break;

		case WM_NOTIFY:
		{
			return(TOTPViewNotify(hWnd,(LPNMHDR)lParam));
		}

		case WM_USER:
		{
			SetFocus(hEditListWindow);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			// Notify the view procedure that it can continue
			// and exit.
			//...............................................
			SetEvent(hSendersEvent);
			bEditWindowDisplayed = FALSE;
		}
		break;

        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
	return(0L);
}

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contens of a true one time pad.
//..............................................................
LRESULT TOTPViewNotify(HWND hWnd, LPNMHDR lpNmhdr)
{
	LPNMLVDISPINFO		lpLvdi;
	DWORD				dwIndex;
	BOOL				bResult;
	DWORD				dwBytesRead;
	LARGE_INTEGER		li;
	DWORD				dwHighAddress;
	DWORD				dwLowAddress;
	
	switch (lpNmhdr->code)
	{
		case LVN_GETDISPINFO:
		{
			lpLvdi = (LPNMLVDISPINFO)lpNmhdr;

			// Determine the index of the item we need and read
			// it into the buffer. Each block of data is 16 bytes long.
			//.........................................................
			dwIndex = lpLvdi->item.iItem;
			li.QuadPart = (dwIndex * 16);
			li.QuadPart = SetMyFilePointer((LPTSTR)&szTOTPFile,hTOTPFile,li.QuadPart,
										    FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				DestroyWindow(hWnd);
			}
			bResult = ReadMyFile((LPTSTR)&szTOTPFile,hTOTPFile,lpKeyBuffer1,
				                  BLOCK_SIZE,&dwBytesRead,NULL);
			if (!bResult)
			{
				DestroyWindow(hWnd);
			}
			// Fill in the items state. Always 0 for this procedure.
			//......................................................
			if (lpLvdi->item.mask & LVIF_STATE)
			{
				lpLvdi->item.state = 0;
			}
			// Fill in the text for the item and subitems.
			//............................................
			if (lpLvdi->item.mask & LVIF_TEXT)
			{
				switch(lpLvdi->item.iSubItem)
				{
					case 0:
					{
						// Display the address.
						//.....................
						dwHighAddress = LOWORD(li.HighPart);
						dwLowAddress = li.LowPart;
						StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%.2X%.8X"),
										dwHighAddress,dwLowAddress);
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 1:
					{
						dwCharInLine = BLOCK_SIZE;
						if (dwIndex == dwLastLine)
						{
							dwCharInLine = dwCharOnLastLine;
						}
						// Display the hexadecimal text.
						//..............................
						__asm
						{
							mov		esi,lpKeyBuffer1
							mov		edi,offset szBuffer
							mov		edx,0
							mov		ecx,dwCharInLine
						L1:	xor		eax,eax
							lodsb
							BHEX
							add		ax,'00'
							cmp		al,'9'
							jbe		L2
							add		al,7h
						L2:	cmp		ah,'9'
							jbe		L3
							add		ah,7h
						L3:	xchg	ah,al
							stosb
							xchg	ah,al
							stosb
							mov		al,20h
							stosb
							cmp		edx,7
							jne		L4
							stosb
						L4:	inc		edx
							dec		ecx
							jnz		L1
							dec		edi
							mov		al,0
							stosb
						}
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 2:
					{
						dwCharInLine = BLOCK_SIZE;
						if (dwIndex == dwLastLine)
						{
							dwCharInLine = dwCharOnLastLine;
						}
						// Display the character text. First we have
						// to change all characters below 20h to 2eh.
						//...........................................
						__asm
						{
							mov		esi,lpKeyBuffer1
							mov		edi,offset szBuffer
							mov		ecx,dwCharInLine
						L5:	xor		eax,eax
							lodsb
							cmp		al,20h
							jb		L6
							cmp		al,7fh
							jb		L7
							cmp		al,91h
							je		L7
							cmp		al,92h
							je		L7
							cmp		al,9fh
							ja		L7
						L6:	mov		al,2eh
						L7:	stosb
							dec		ecx
							jnz		L5
							mov		al,0
							stosb
						}
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					default:
						break;
				}
			}
		}
		break;

		case LVN_KEYDOWN:
		{
			LPNMLVKEYDOWN		lpKdn;

			lpKdn = (LPNMLVKEYDOWN)lpNmhdr;

			if (lpKdn->wVKey == VK_ESCAPE)
			{
				SendMessage(hWnd,WM_CLOSE,0,0);
			}
		}
		break;

		// We do not select any thing in this virtual window.
		// Just return 0.
		//...................................................
		case LVN_ITEMACTIVATE:
			break;

		// These two messages are not currently used by the program.
		//..........................................................
		case LVN_ODCACHEHINT:
        case LVN_ODFINDITEM:
			break;

		default:
			break;
	}
	return(0);
}

// Create the virtual list view window for viwing our true one time pad file.
//...........................................................................
HWND CreateTOTPListView(HWND hWndParent)
{
	DWORD       dwStyle;
	HWND        hWndListView;
	LVCOLUMN	lvColumn;
	int			i;
	TCHAR		szColumns[3][16] = {TEXT("Address"),
									TEXT("Hexadecimal"),
									TEXT("Characters")};

	int			iColumnSize[3] = {88,396,144};

	dwStyle =   WS_TABSTOP | 
				WS_CHILD | 
				WS_BORDER | 
				WS_VISIBLE |
				LVS_NOSORTHEADER |
				LVS_REPORT | 
				LVS_OWNERDATA;
	  
	hWndListView = CreateWindowEx(WS_EX_CLIENTEDGE,WC_LISTVIEW,NULL,
                                  dwStyle,0,0,0,0,hWndParent,
                                  (HMENU)IDC_TOTPLISTVIEW,hInst,NULL);

	if(!hWndListView)
	{
		return(0);
	}
	// Set the extended styles for the virtual list box.
	//..................................................
	ListView_SetExtendedListViewStyleEx(hWndListView,0,LVS_EX_GRIDLINES);

	SendMessage(hWndListView,WM_SETFONT,
			   (WPARAM)GetStockObject(ANSI_FIXED_FONT),FALSE);

	// Resize the window to fit in the parent windows.
	//................................................
	ResizeEditListView(hWndListView, hWndParent);

	// Set the header columns for the virtual list view window.
	//.........................................................
	lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	for(i = 0; i < 3; i++)
	{
		lvColumn.fmt = LVCFMT_LEFT;
		lvColumn.pszText = szColumns[i];
		lvColumn.cx = iColumnSize[i];
		SendMessage(hWndListView,LVM_INSERTCOLUMN,(WPARAM)i,(LPARAM)&lvColumn);
	}
	// Empty the list.
	//................
	SendMessage(hWndListView,LVM_DELETEALLITEMS,0,0);

	// Set the number of items in the list.
	//.....................................
	SendMessage(hWndListView,LVM_SETITEMCOUNT,(WPARAM)dwLineCount,
			   (LPARAM)LVSICF_NOINVALIDATEALL);

	// Set the callback mask so we can control the state information.
	//...............................................................
	SendMessage(hWndListView,LVM_SETCALLBACKMASK,(WPARAM)LVIS_SELECTED | LVIS_FOCUSED,0);

	return(hWndListView);
}

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizeTOTPListView(HWND hWndListView, HWND hWndParent)
{
	RECT  rc;

	GetClientRect(hWndParent, &rc);

	MoveWindow(hWndListView, rc.left,rc.top,rc.right - rc.left,rc.bottom - rc.top,TRUE);
}
